// Playground - noun: a place where people can play

import UIKit

struct Hotel {
    // Informacje dotyczące hotelu.
}

struct HotelBooking {
    static func getHotelNameForDates(to: Date, from: Date) -> [Hotel]? {
        let hotels = [Hotel]()
        // Logika odpowiedzialna za pobranie hoteli.
        return hotels
    }
    
    static func bookHotel(hotel: Hotel) {
        // Logika odpowiedzialna za rezerwację miejsca w hotelu.
    }
}


struct Flight {
    // Informacje dotyczące lotu.
}

struct FlightBooking {
    static func getFlightNameForDates(to: Date, from: Date) -> [Flight]? {
        let flights = [Flight]()
        // Logika odpowiedzialna za pobranie lotów.
        return flights
    }
    
    static func bookFlight(fight: Flight) {
        // Logika odpowiedzialna za rezerwację lotu.
    }
}


struct RentalCar {
    // Informacje dotyczące samochodu do wynajęcia.
}

struct RentalCarBooking {
    static func getRentalCarNameForDates(to: Date, from: Date) -> [RentalCar]? {
        let cars = [RentalCar]()
        // Logika odpowiedzialna za pobranie samochodów do wynajęcia.
        return cars
    }
    
    static func bookRentalCar(rentalCar: RentalCar) {
        // Logika odpowiedzialna za zarezerwowanie samochodu do wynajęcia.
    }
}


class TravelFacade {
    
    var hotels: [Hotel]?
    var flights: [Flight]?
    var cars: [RentalCar]?
    
    init(to: Date, from: Date) {
        hotels = HotelBooking.getHotelNameForDates(to: to, from: from)
        flights = FlightBooking.getFlightNameForDates(to: to, from: from)
        cars = RentalCarBooking.getRentalCarNameForDates(to: to, from: from)
    }
    
    func bookTrip(hotel: Hotel, flight: Flight, rentalCar: RentalCar) {
        HotelBooking.bookHotel(hotel: hotel)
        FlightBooking.bookFlight(fight: flight)
        RentalCarBooking.bookRentalCar(rentalCar: rentalCar)
    }
}

